let amplitudeSlider;
let frequencySlider;
let state = 1;

function setup() {
  createCanvas(800, 600);
  
  // Create sliders for amplitude and frequency
  amplitudeSlider = createSlider(0, 100, 50);
  amplitudeSlider.position(10, height + 10);
  frequencySlider = createSlider(0, 10, 5, 0.1);
  frequencySlider.position(10, height + 30);
}

function draw() {
  background(244, 194, 194);

  if (state === 1) {
    // Get mouse position and map to amplitude and frequency values
    let amplitude = amplitudeSlider.value();
    let frequency = frequencySlider.value();
    let mouseXValue = map(mouseX, 0, width, -TWO_PI, TWO_PI);
    
    // Draw sine wave based on mouse position
    stroke(0);
    strokeWeight(2);
    noFill();
    beginShape();
    for (let x = 0; x < width; x++) {
      let y = height / 2 + amplitude * sin(mouseXValue + x * frequency);
      vertex(x, y);
    }
    endShape();
  } else if (state === 2) {
    // Draw a circle in the center of the canvas
    noStroke();
    fill(255, 0, 0);
    ellipse(width / 2, height / 2, 50, 50);
  }
}

// Toggle between states when a key is pressed
function keyPressed() {
  if (state === 1) {
    state = 2;
  } else {
    state = 1;
  }
}
